def sign(x): 
    """Determine the sign of x.

    Returns: 
        -1 if x is negative, +1 if x is positive or 0 if x is zero. """ 
    return (x > 0) - (x < 0)

def orientation(p, q, r):  
    """Determine the orientation of three points in the plane.

    Args:
        p, q, r: Two-tuples representing coordinate pairs of three points.

    Returns:
        -1 if p, q, r is a turn to the right, +1 if p, q, r is a turn to the
        left, otherwise 0 if p, q, and r are collinear.
    """ 
    d = (q[0] - p[0]) * (r[1] - p[1]) - (q[1] - p[1]) * (r[0] - p[0])
    return sign(d)


def main():
    """ Test whether points immediately above and below the point (0.5, 0.5)
    lie above, on, or below the line through (12.0, 12.0) and (24.0, 24.0).
    """
    px = 0.5
    
    pys = [0.49999999999999,
           0.49999999999999006,
           0.4999999999999901,
           0.4999999999999902,
           0.49999999999999023,
           0.4999999999999903,
           0.49999999999999034,
           0.4999999999999904,
           0.49999999999999045,
           0.4999999999999905,
           0.49999999999999056,
           0.4999999999999906,
           0.4999999999999907,
           0.49999999999999073,
           0.4999999999999908,
           0.49999999999999084,
           0.4999999999999909,
           0.49999999999999095,
           0.499999999999991,
           0.49999999999999106,
           0.4999999999999911,
           0.4999999999999912,
           0.49999999999999123,
           0.4999999999999913,
           0.49999999999999134,
           0.4999999999999914,
           0.49999999999999145,
           0.4999999999999915,
           0.49999999999999156,
           0.4999999999999916,
           0.4999999999999917,
           0.49999999999999173,
           0.4999999999999918,
           0.49999999999999184,
           0.4999999999999919,
           0.49999999999999195,
           0.499999999999992,
           0.49999999999999206,
           0.4999999999999921,
           0.4999999999999922,
           0.49999999999999223,
           0.4999999999999923,
           0.49999999999999234,
           0.4999999999999924,
           0.49999999999999245,
           0.4999999999999925,
           0.49999999999999256,
           0.4999999999999926,
           0.4999999999999927,
           0.49999999999999273,
           0.4999999999999928,
           0.49999999999999284,
           0.4999999999999929,
           0.49999999999999295,
           0.499999999999993,
           0.49999999999999306,
           0.4999999999999931,
           0.49999999999999317,
           0.4999999999999932,
           0.4999999999999933,
           0.49999999999999334,
           0.4999999999999934,
           0.49999999999999345,
           0.4999999999999935,
           0.49999999999999356,
           0.4999999999999936,
           0.49999999999999367,
           0.4999999999999937,
           0.4999999999999938,
           0.49999999999999384,
           0.4999999999999939,
           0.49999999999999395,
           0.499999999999994,
           0.49999999999999406,
           0.4999999999999941,
           0.49999999999999417,
           0.4999999999999942,
           0.4999999999999943,
           0.49999999999999434,
           0.4999999999999944,
           0.49999999999999445,
           0.4999999999999945,
           0.49999999999999456,
           0.4999999999999946,
           0.49999999999999467,
           0.4999999999999947,
           0.4999999999999948,
           0.49999999999999484,
           0.4999999999999949,
           0.49999999999999495,
           0.499999999999995,
           0.49999999999999506,
           0.4999999999999951,
           0.49999999999999517,
           0.4999999999999952,
           0.4999999999999953,
           0.49999999999999534,
           0.4999999999999954,
           0.49999999999999545,
           0.4999999999999955,
           0.49999999999999556,
           0.4999999999999956,
           0.49999999999999567,
           0.4999999999999957,
           0.4999999999999958,
           0.49999999999999584,
           0.4999999999999959,
           0.49999999999999595,
           0.499999999999996,
           0.49999999999999606,
           0.4999999999999961,
           0.49999999999999617,
           0.4999999999999962,
           0.4999999999999963,
           0.49999999999999634,
           0.4999999999999964,
           0.49999999999999645,
           0.4999999999999965,
           0.49999999999999656,
           0.4999999999999966,
           0.49999999999999667,
           0.4999999999999967,
           0.4999999999999968,
           0.49999999999999684,
           0.4999999999999969,
           0.49999999999999695,
           0.499999999999997,
           0.49999999999999706,
           0.4999999999999971,
           0.49999999999999717,
           0.4999999999999972,
           0.4999999999999973,
           0.49999999999999734,
           0.4999999999999974,
           0.49999999999999745,
           0.4999999999999975,
           0.49999999999999756,
           0.4999999999999976,
           0.49999999999999767,
           0.4999999999999977,
           0.4999999999999978,
           0.49999999999999784,
           0.4999999999999979,
           0.49999999999999795,
           0.499999999999998,
           0.49999999999999806,
           0.4999999999999981,
           0.49999999999999817,
           0.4999999999999982,
           0.4999999999999983,
           0.49999999999999833,
           0.4999999999999984,
           0.49999999999999845,
           0.4999999999999985,
           0.49999999999999856,
           0.4999999999999986,
           0.49999999999999867,
           0.4999999999999987,
           0.4999999999999988,
           0.49999999999999883,
           0.4999999999999989,
           0.49999999999999895,
           0.499999999999999,
           0.49999999999999906,
           0.4999999999999991,
           0.49999999999999917,
           0.4999999999999992,
           0.4999999999999993,
           0.49999999999999933,
           0.4999999999999994,
           0.49999999999999944,
           0.4999999999999995,
           0.49999999999999956,
           0.4999999999999996,
           0.49999999999999967,
           0.4999999999999997,
           0.4999999999999998,
           0.49999999999999983,
           0.4999999999999999,
           0.49999999999999994, # The previous representable float less than 0.5
           0.5,
           0.5000000000000001, # The next representable float greater than 0.5
           0.5000000000000002,
           0.5000000000000003,
           0.5000000000000004,
           0.5000000000000006,
           0.5000000000000007,
           0.5000000000000008,
           0.5000000000000009,
           0.500000000000001,
           0.5000000000000011,
           0.5000000000000012,
           0.5000000000000013,
           0.5000000000000014,
           0.5000000000000016,
           0.5000000000000017,
           0.5000000000000018,
           0.5000000000000019,
           0.500000000000002,
           0.5000000000000021,
           0.5000000000000022,
           0.5000000000000023,
           0.5000000000000024,
           0.5000000000000026,
           0.5000000000000027,
           0.5000000000000028,
           0.5000000000000029,
           0.500000000000003,
           0.5000000000000031,
           0.5000000000000032,
           0.5000000000000033,
           0.5000000000000034,
           0.5000000000000036,
           0.5000000000000037,
           0.5000000000000038,
           0.5000000000000039,
           0.500000000000004,
           0.5000000000000041,
           0.5000000000000042,
           0.5000000000000043,
           0.5000000000000044,
           0.5000000000000046,
           0.5000000000000047,
           0.5000000000000048,
           0.5000000000000049,
           0.500000000000005,
           0.5000000000000051,
           0.5000000000000052,
           0.5000000000000053,
           0.5000000000000054,
           0.5000000000000056,
           0.5000000000000057,
           0.5000000000000058,
           0.5000000000000059,
           0.500000000000006,
           0.5000000000000061,
           0.5000000000000062,
           0.5000000000000063,
           0.5000000000000064,
           0.5000000000000066,
           0.5000000000000067,
           0.5000000000000068,
           0.5000000000000069,
           0.500000000000007,
           0.5000000000000071,
           0.5000000000000072,
           0.5000000000000073,
           0.5000000000000074,
           0.5000000000000075,
           0.5000000000000077,
           0.5000000000000078,
           0.5000000000000079,
           0.500000000000008,
           0.5000000000000081,
           0.5000000000000082,
           0.5000000000000083,
           0.5000000000000084,
           0.5000000000000085,
           0.5000000000000087,
           0.5000000000000088,
           0.5000000000000089,
           0.500000000000009,
           0.5000000000000091,
           0.5000000000000092,
           0.5000000000000093,
           0.5000000000000094,
           0.5000000000000095,
           0.5000000000000097,
           0.5000000000000098,
           0.5000000000000099,
           0.50000000000001]

    q = (12.0, 12.0)
    r = (24.0, 24.0)
    
    for py in pys:
        p = (px, py)
        o = orientation(p, q, r)
        #print("orientation(({p[0]:>3}, {p[1]:<19}) q, r) -> {o:>2}".format(p=p, o=o))

    #Graphical representation
    import bmp
    color = {-1: 0, 0: 127, +1: 255}
    pixels = [[color[orientation((px, py), q, r)] for px in pys]
              for py in reversed(pys)]
    bmp.write_grayscale('above_below_float.bmp', pixels)
        
if __name__ == '__main__':
    main()
